#include <iostream>
#include <cstdio>
#include <string.h>
#include <string>
#include <algorithm>
#include <cmath>
#include <queue>
#include <stack>
#include <vector>
#include <map>
#include <set>
#include <cassert>
#include <time.h>
#include <cstdlib>

using namespace std;

#define ll long long
#define ld long double
#define mp make_pair
#define pb push_back
#define fst first
#define snd second
#define y0 asfdasdfasf
#define y1 askfjasjfas

const int maxn = 40004;
const int inf = 1e9;

struct maxFlow
{
	vector < pair < int, int > > g[maxn];
	vector < pair < int, int > > gt[maxn];
	int f[maxn];
	int c[maxn];

	int eCnt;
	int n;

	int s, t;

	int lvl[maxn];
	int pr[maxn];

	int dist[2][maxn];

	void calcDist(int *d, int st, vector < pair < int, int > > *gg)
	{
		for (int i = 1; i <= n; i++)
			d[i] = inf;

		queue < int > q;
		q.push(st);
		d[st] = 0;

		while (!q.empty())
		{
			int v = q.front();
			q.pop();

			for (int i = 0; i < gg[v].size(); i++)
			{
				int to = gg[v][i].fst;
				int ee = gg[v][i].snd;

				if (d[to] <= d[v] + 1)
					continue;

				if (!(f[ee] < c[ee]))
					continue;

				d[to] = d[v] + 1;
				q.push(to);
			}
		}

	}

	maxFlow(int _n)
	{
		n = _n;
		eCnt = 0;
	}

	void addEdge(int u, int v, int cap)
	{
		f[eCnt] = f[eCnt + 1] = 0;
		c[eCnt] = cap;
		c[eCnt + 1] = 0;
		g[u].pb(mp(v, eCnt));
		g[v].pb(mp(u, eCnt + 1));

		gt[v].pb(mp(u, eCnt));
		gt[u].pb(mp(v, eCnt + 1));

		eCnt += 2;
	}


	bool bfs()
	{
		for (int i = 1; i <= n; i++)
		{
			lvl[i] = -1;
		}

		queue < int > q;
		q.push(s);

		lvl[s] = 0;

		while (!q.empty())
		{
			int v = q.front();
			q.pop();

			for (int i = 0; i < g[v].size(); i++)
			{
				int to = g[v][i].fst;
				int ee = g[v][i].snd;

				if (lvl[to] != -1)
					continue;

				if (!(f[ee] < c[ee]))
					continue;

				lvl[to] = lvl[v] + 1;
				q.push(to);
			}
		}

		return lvl[t] != -1;
	}


	int dfs(int v, int flow)
	{
		if (!flow || v == t)
			return flow;

		for (; pr[v] < g[v].size(); pr[v]++)
		{
			int to = g[v][pr[v]].fst;
			int ee = g[v][pr[v]].snd;

			if (lvl[v] + 1 != lvl[to])
				continue;

			if (int res = dfs(to, min(flow, c[ee] - f[ee])))
			{
				f[ee] += res;
				f[ee ^ 1] -= res;
				return res;
			}
		}

		return 0;
	}


	pair < int, int > flow()
	{
		while (bfs())
		{
			for (int i = 1; i <= n; i++)
				pr[i] = 0;

			while (dfs(s, inf))
			{

			}
		

		}

		int res = 0;

		for (int i = 0; i < g[s].size(); i++)
			if ((g[s][i].snd & 1) == 0)
				res += f[g[s][i].snd];

		calcDist(dist[0], s, g);
		calcDist(dist[1], t, gt);

		int cnt = 0;

		for (int i = 1; i <= n; i++)
		{
			for (int j = 0; j < g[i].size(); j++)
			{
				int to = g[i][j].fst;
				int ee = g[i][j].snd;

				if (ee & 1)
					continue;

				if (!(dist[1][i] != inf && dist[0][to] != inf))
				{
					continue;
				}

				cnt++;
			}
		}

		if (cnt)
			return mp(res + 1, cnt);
		else
			return mp(res, 0);
	}


};

int main()
{
	//freopen("a.in", "r", stdin);
	while (true)
	{
		int n, m, s, t;
		scanf("%d %d %d %d", &n, &m, &s, &t);

		if (!n && !m && !s && !t)
			break;

		maxFlow *flow = new maxFlow(n);

		for (int i = 0; i < m; i++)
		{
			int u, v;
			scanf("%d %d", &u, &v);
			flow->addEdge(u, v, 1);
		}

		flow->s = s;
		flow->t = t;

		pair < int, int > res = flow->flow();

		cout << res.fst << " " << res.snd << endl;

		delete flow;
	}
	
	return 0;
}
